/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.pkcs.bc;

import amp_libs.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.crypto.CipherParameters;
import amp_libs.org.bouncycastle.crypto.ExtendedDigest;
import amp_libs.org.bouncycastle.crypto.digests.SHA1Digest;
import amp_libs.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import amp_libs.org.bouncycastle.crypto.io.CipherInputStream;
import amp_libs.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import amp_libs.org.bouncycastle.operator.GenericKey;
import amp_libs.org.bouncycastle.operator.InputDecryptor;
import amp_libs.org.bouncycastle.operator.InputDecryptorProvider;
import amp_libs.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(algorithmIdentifier, PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

